var kaspersyLabSessionInstance = null;
(function ( ns) {
	var prefix = ns.PREFIX || "%PREFIX%";
	var signature = ns.SIGNATURE || "%SIGNATURE%";
	var workIdentifiersString = ns.WORK_IDENTIFIERS || "";
	var cspNonce = ns.CSP_NONCE || "%CSP_NONCE%"
	if (workIdentifiersString)
	{
		var workIdentifiers = workIdentifiersString.split(",");

		(function ( signature) {
			var pattern = signature.toLowerCase();

			for (var i = 0, scriptsCount = document.scripts.length; i < scriptsCount; ++i) {
				 var tag = document.scripts[i];
				if (typeof tag.src === 'string' && tag.src.length > 76 &&
					tag.src.toLowerCase().indexOf(pattern) > 0 &&
					/\/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}\/main.js/.test(tag.src)) {
					for (var i = 0; i < workIdentifiers.length; ++i)
						window[workIdentifiers[i]] = true;
					tag.parentElement.removeChild(tag);
					return; 
				}
			}
		})(signature);
	}

	function IsDefined(variable)
	{
		return "undefined" !== typeof(variable);
	}

	var PluginReceiver = function()
	{
		var m_started = false;

		this.StartReceive = function(callMethod, errorCallback)
		{
			KLBrowserExtension.callContentObject("registerReceiver",
				{ callback: callMethod,
				  errback: errorCallback },
				null, 
				function() {
					m_started = true;
				},
				true);
		};

		this.StopReceive = function()
		{
			KLBrowserExtension.callContentObject("unregisterReceiver",
				null, 
				null, 
				function() {
					m_started = false;
				},
				true);
		};

		this.IsStarted = function()
		{
			return m_started;
		};

		this.IsProductConnected = function()
		{
			return true; 
		};
	};

	var PluginCaller = function()
	{
		var self = this;
		function CallImpl(command, commandAttribute, data, callbackResult, callbackError)
		{
			KLBrowserExtension.callGlobalObject("callPlugin",
				{ command: command,
				  commandAttribute: commandAttribute || "",
				  commandData: data || "",
				  sessionId: self.sessionId || "" },
				function(rData) {
					if (!IsDefined(rData)) return;
					if (IsDefined(rData.error)) {
                        if (callbackError)
						  callbackError(rData.error);
                        ns.Log("Command '" + command + "' failed: " + rData.error);
					}
					else if (callbackResult) {
						callbackResult(rData);
					}
				}, true); 
		}

		this.Start = function(callbackSuccess)
		{
			callbackSuccess();
		}

		this.SendLog = function(message)
		{
			CallImpl("log", null, message);
		}

		this.Call = function(command, commandAttribute, data, isAsync, callbackResult, callbackError)         
		{
			if (IsDefined(isAsync) && !isAsync)
				return false;

			CallImpl(command,
				commandAttribute,
				data,
				callbackResult
				    ? function(result) {
                        if (result) {
                            var command = typeof result === "string" ? JSON.parse(result) : result;
                            callbackResult(command.result, command.parameters, command.method);
                        } else {
                            callbackResult();
                        }
					}
					: null,
				callbackError);
		}

		this.InitCall = function(pluginsInitData, callbackResult, callbackError)
		{
			var initData = {
				url: document.location.href,
				plugins: (IsDefined(ns.PLUGINS_LIST)) ? ns.PLUGINS_LIST : "%PLUGINS_LIST%",
                data: { data: pluginsInitData },
				isTopLevel: (window && window == window.top)
			};

			if (document.location.href == "data:text/html,chromewebdata")                                     
				return callbackError();                                                                       
			CallImpl("init",
				null,
				initData,
				function(initResponse) {
					self.sessionId = initResponse.sessionId;
					callbackResult(initResponse.initSettings);
				},
                callbackError);
		}

		this.GetReceiver = function()
		{
			return new PluginReceiver();
		}
	};

	var CallReceiver = function (caller) {
		var m_plugins = {};
		var m_receiver = caller.GetReceiver();
		var m_caller = caller;

        this.RegisterMethod = function (methodName, callback) {
            var pluginId = GetPluginIdFromMethodName(methodName);
            if (pluginId) {
                var methods = GetPluginMethods(pluginId);
                if (methods) {
                    if (methods[methodName]) {
                        throw 'Already registered method ' + methodName;
                    }
                    methods[methodName] = callback;
                }
                else {
                    throw 'Cannot registered ' + methodName;
                }
            }
        };

        this.RegisterPlugin = function (pluginId, callbackPing, callbackError) {
            if (m_plugins[pluginId]) {
                throw 'Already started plugin ' + pluginId;
            }

            var plugin = {
                onError: callbackError,
                onPing: callbackPing,
                methods: {}
            };

            m_plugins[pluginId] = plugin;

			if (!m_receiver.IsStarted())
				m_receiver.StartReceive(CallMethod, ReportError, UpdateDelay);
        };

        this.UnregisterPlugin = function (pluginId) {
			delete m_plugins[pluginId];

			if (IsPluginListEmpty())
				m_receiver.StopReceive();
        };

        this.UnregisterAll = function () {
            if (IsPluginListEmpty())
                return;
            m_receiver.StopReceive();
            m_plugins = {};
        };

        this.IsEmpty = IsPluginListEmpty;

        function IsPluginListEmpty() {
            for (var key in m_plugins) {
                if (m_plugins.hasOwnProperty(key))
                    return false;
            }
            return true;
        }
		this.IsProductConnected = function()
		{
			return m_receiver.IsProductConnected();
		}

        function UpdateDelay() {
            var newDelay = ns.MaxRequestDelay;
            var currentTime = ns.GetCurrentTime();

            for (var pluginId in m_plugins) {
                try {
                    var onPing = m_plugins[pluginId].onPing;
                    if (onPing) {
                        var delay = onPing(currentTime);
                        if (delay < newDelay && delay > 0 && delay < ns.MaxRequestDelay) {
                            newDelay = delay;
                        }
                    }
                }
                catch (e) {
                    ReportPluginError(pluginId, 'UpdateDelay: ' + (e.message || e));
                }
            }

            return newDelay;
        }

        function ReportPluginError(pluginId, status) {
            var onError = m_plugins[pluginId].onError;
            if (onError)
                onError(status);
        }

        function ReportError(status) {
            for (var pluginId in m_plugins)
                ReportPluginError(pluginId, status);
        }

        function GetPluginIdFromMethodName(methodName) {
            if (methodName) {
                var names = methodName.split('.', 2);
                if (names.length === 2) {
                    return names[0];
                }
            }
            return null;
        }

        function GetPluginMethods(pluginId) {
            var plugin = m_plugins[pluginId];
            return plugin ? plugin.methods : null;
        }

        function CallPluginMethod(pluginId, methodName, args) {
            var methods = GetPluginMethods(pluginId);
            if (methods) {
                var callback = methods[methodName];
                if (callback) {
                    try {
                        callback(args);
						m_caller.SendLog(methodName + " executed.");
                        return true;
                    }
                    catch (e) {
						m_caller.SendLog("Call " + methodName + " in plugin " + pluginId + " error: " + (e.message || e));
                    }
                }
            }
            m_caller.SendLog("Cannot call " + methodName + " for plugin " + pluginId);
            return false;
        }
		function CallMethod(methodName, args)
		{
			ns.Log("Try to find js callback " + methodName);
			var pluginId = GetPluginIdFromMethodName(methodName);
			if (pluginId)
				CallPluginMethod(pluginId, methodName, args);
		}
    };

    var KasperskyLabSessionClass = function (caller) {
        var self = this;
		var m_caller = caller;
        var m_callReceiver = new CallReceiver(caller);

		function CallImpl(methodName, arrayOfArgs, callbackResult, callbackError, isAsync) {
			var data = (arrayOfArgs && arrayOfArgs.length) ? arrayOfArgs : [];
			return m_caller.Call("to", methodName, data, isAsync, callbackResult, callbackError);
		}

        function Call(methodName, arrayOfArgs, callbackResult, callbackError) {
			CallImpl(methodName, arrayOfArgs, callbackResult, callbackError, true);
        }

        function SyncCall(methodName, arrayOfArgs, callbackResult, callbackError) {
			return CallImpl(methodName, arrayOfArgs, callbackResult, callbackError, false);
        }

        function Stop() {
            try {
                m_callReceiver.UnregisterAll();
                ns.Log("session stopped");
				if (m_callReceiver.IsProductConnected())
				{
					if (!m_caller.Call("shutdown", null, null, false))
						m_caller.Call("shutdown");
				}
            }
            catch (e) {
            }
        }

        function DeactivatePlugin(pluginId) {
            ns.Log('DeactivatePlugin ' + pluginId);
            m_callReceiver.UnregisterPlugin(pluginId);
            if (m_callReceiver.IsEmpty()) {
                Stop();
            }
        }

        function ActivatePlugin(pluginId, callbackPing, callbackError) {
            ns.Log('ActivatePlugin ' + pluginId);

            m_callReceiver.RegisterPlugin(pluginId, callbackPing, function (e) {
                callbackError && callbackError(e);
                m_callReceiver.UnregisterPlugin(pluginId);
                if (m_callReceiver.IsEmpty()) {
                    Stop();
                }
            });
        }

        function RegisterMethod(methodName, callback) {
            ns.Log('RegisterMethod ' + methodName);
            m_callReceiver.RegisterMethod(methodName, callback);
        }

		this.Log = function(error) 
		{
			try
			{
				var msg = "" + (error.message || error);
				if (error.stack)
					msg += "\r\n" + error.stack;
				msg && msg.length <= 2048 ? m_caller.SendLog(msg) : m_caller.SendLog(msg.substring(0, 2048) + '<...>');
			}
			catch(e)
			{
				ns.Log(e.message || e);
			}
		};

        this.InitializePlugin = function (init) {
            init(
                function () {
                    ActivatePlugin.apply(self, arguments);
                },
                function () {
                    RegisterMethod.apply(self, arguments);
                },
                function () {
                    Call.apply(self, arguments);
                },
                function () {
                    DeactivatePlugin.apply(self, arguments);
                },
                function () {
                    return SyncCall.apply(self, arguments);
                }
            );
        };
		ns.AddEventListener(window, "beforeunload", function() 
			{
				if (!m_callReceiver.IsEmpty())
					Stop();
			});
    };

	var runners = {};
	var pluginsInitData = [];
	ns.AddRunner = function(pluginName, runnerFunc, initParameters)
	{
		runners[pluginName] = runnerFunc;
		if (initParameters)
		{
			pluginsInitData.push({plugin: pluginName, parameters: initParameters});
		}
	};

	ns.SessionLog = function(e)
	{
		if (kaspersyLabSessionInstance)
			kaspersyLabSessionInstance.Log(e);
	}

	ns.ContentSecurityPolicyNonceAttribute = cspNonce;

	var SupportedCallerProvider = function()
	{
		var m_current = 0;
		var m_supportedCallers = [];
		m_supportedCallers.push(new PluginCaller);

		function FindSupportedImpl(callbackSuccess)
		{
			if (m_current < m_supportedCallers.length)
			{
				var caller = m_supportedCallers[m_current++];
				caller.Start(function(){callbackSuccess(caller);}, function(){FindSupportedImpl(callbackSuccess);});
			}
			else
			{
				m_current = 0;
				PostponeInit();
			}
		}

		this.FindSupported = function(callbackSuccess)
		{
			FindSupportedImpl(callbackSuccess);
		}
	}

	function Init()
	{
		var callerProvider = new SupportedCallerProvider;
		callerProvider.FindSupported(
			function(caller) 
			{
				caller.InitCall(
					pluginsInitData,
					function(initSettings)
					{
						ns.IsRtl = initSettings.rtl;
						ns.GetResourceSrc = function(resource) {
							return KLBrowserExtension.getExtensionResourcePath(resource);
						}
						kaspersyLabSessionInstance = new KasperskyLabSessionClass(caller);
						var plugins = initSettings.plugins;
						for (var i = 0, pluginsCount = plugins.length; i < pluginsCount; ++i)
						{
							var plugin = plugins[i];
							var pluginRunnerFunction = runners[plugin.name];
							if (pluginRunnerFunction)
								pluginRunnerFunction(KasperskyLab, kaspersyLabSessionInstance, plugin.settings, plugin.localization);
						}
					},
					function()
					{
						PostponeInit();
					});
			});
	}

	var postponedInitTimeout = null;
	function PostponeInit()
	{
		clearTimeout(postponedInitTimeout)
		postponedInitTimeout = ns.SetTimeout(function () { Init(); }, 60 * 1000);
	}

	ns.SetTimeout(function () { Init(); }, 0);
})(KasperskyLab);
